<?php
$default_settings = [
    'col_xl' => '4',
    'col_lg' => '4',
    'col_md' => '3',
    'col_sm' => '2',
    'col_xs' => '1',
    'content_list' => '',
    'thumbnail_size' => '',
    'thumbnail_custom_dimension' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$col_xl = intval($col_xl) > 0 ? 12 / intval($col_xl) : 3;
$col_lg = intval($col_lg) > 0 ? 12 / intval($col_lg) : 3;
$col_md = intval($col_md) > 0 ? 12 / intval($col_md) : 4;
$col_sm = intval($col_sm) > 0 ? 12 / intval($col_sm) : 6;
$col_xs = intval($col_xs) > 0 ? 12 / intval($col_xs) : 12;
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="ct-grid ct-testimonial-grid5">
        <div class="ct-grid-inner ct-grid-masonry row animate-time" data-gutter="3">            
            <?php foreach ($content_list as $key => $value):
    			$title = isset($value['title']) ? $value['title'] : '';
                $position = isset($value['position']) ? $value['position'] : '';
                $title_testimonial = isset($value['title_testimonial']) ? $value['title_testimonial'] : '';
                $description = isset($value['description']) ? $value['description'] : '';
    			$image = isset($value['image']) ? $value['image'] : '';
    			$img = consultio_get_image_by_size( array(
                    'attach_id'  => $image['id'],
                    'thumb_size' => '300x300',
                ));
                $thumbnail = $img['thumbnail']; 
                $social = isset($value['social']) ? $value['social'] : '';
                
                $current_item_class = $item_class;
                if (count($content_list) == 3) {
                    if ($key < 2) {
                        $current_item_class = "grid-item col-xl-3 col-lg-12 col-md-12 col-sm-12 col-12";
                    } else {
                        $current_item_class = "grid-item col-xl-9 col-lg-12 col-md-12 col-sm-12 col-12";
                    }
                }
                ?>
                <div class="<?php echo esc_attr($current_item_class); ?>">
                    <div class="item--inner <?php echo esc_attr($ct_animate); ?>">
                        <div class="item--content">
                            <div class="item-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none">
                                    <path d="M7.47623 27.091C5.7164 27.0891 4.0292 26.3891 2.7848 25.1447C1.54041 23.9003 0.840463 22.2131 0.838532 20.4533C0.838532 20.4423 0.838532 20.431 0.838532 20.42C0.838532 20.3981 0.835694 20.3653 0.833261 20.3219C0.697045 17.9114 1.0911 11.403 7.6761 3.06342C7.7354 2.98852 7.81925 2.93697 7.91286 2.91786C8.00646 2.89875 8.10381 2.91332 8.18772 2.95898C8.27164 3.00465 8.33673 3.07848 8.37151 3.16746C8.4063 3.25643 8.40855 3.35484 8.37786 3.44531C8.35921 3.50044 6.55961 8.89112 7.78921 13.8237C9.52108 13.905 11.1524 14.6606 12.3344 15.9291C13.5163 17.1976 14.155 18.8781 14.1139 20.6114C14.0728 22.3447 13.3552 23.9931 12.1144 25.2042C10.8737 26.4152 9.20839 27.0927 7.47461 27.0918L7.47623 27.091ZM1.64934 20.4764C1.65383 21.6279 1.99938 22.7522 2.64237 23.7074C3.28536 24.6627 4.19695 25.406 5.26207 25.8435C6.32718 26.2811 7.49805 26.3932 8.62686 26.1658C9.75566 25.9384 10.7918 25.3817 11.6044 24.5659C12.4171 23.7501 12.9698 22.7118 13.1928 21.5821C13.4158 20.4524 13.2991 19.282 12.8574 18.2186C12.4157 17.1552 11.6688 16.2465 10.7111 15.6072C9.75338 14.968 8.62772 14.6268 7.47623 14.6268C7.38745 14.6268 7.30113 14.5976 7.23053 14.5438C7.15993 14.4899 7.10895 14.4144 7.08542 14.3288C6.15299 10.9356 6.61029 7.37612 7.07367 5.21612C1.85042 12.5329 1.52245 18.1177 1.64448 20.2765C1.64998 20.343 1.65161 20.4097 1.64934 20.4764Z" fill="currentColor"/>
                                    <path d="M22.5514 27.091C20.7916 27.0891 19.1044 26.3891 17.86 25.1447C16.6156 23.9003 15.9157 22.2131 15.9137 20.4533C15.9137 20.4423 15.9137 20.431 15.9137 20.42C15.9137 20.3981 15.9109 20.3653 15.9085 20.3219C15.7722 17.9114 16.1663 11.403 22.7513 3.06342C22.8106 2.98852 22.8944 2.93697 22.9881 2.91786C23.0817 2.89875 23.179 2.91332 23.2629 2.95898C23.3468 3.00465 23.4119 3.07848 23.4467 3.16746C23.4815 3.25643 23.4837 3.35484 23.4531 3.44531C23.4344 3.50044 21.6348 8.89112 22.8644 13.8237C24.5963 13.905 26.2276 14.6606 27.4095 15.9291C28.5915 17.1976 29.2302 18.8781 29.1891 20.6114C29.148 22.3447 28.4304 23.9931 27.1896 25.2042C25.9489 26.4152 24.2836 27.0927 22.5498 27.0918L22.5514 27.091ZM16.7245 20.4764C16.729 21.6279 17.0746 22.7522 17.7176 23.7074C18.3606 24.6627 19.2721 25.406 20.3373 25.8435C21.4024 26.2811 22.5732 26.3932 23.7021 26.1658C24.8309 25.9384 25.867 25.3817 26.6796 24.5659C27.4923 23.7501 28.045 22.7118 28.268 21.5821C28.491 20.4524 28.3743 19.282 27.9326 18.2186C27.4909 17.1552 26.744 16.2465 25.7863 15.6072C24.8286 14.968 23.7029 14.6268 22.5514 14.6268C22.4626 14.6268 22.3763 14.5976 22.3057 14.5438C22.2351 14.4899 22.1841 14.4144 22.1606 14.3288C21.2282 10.9356 21.6855 7.37612 22.1489 5.21612C16.9256 12.5329 16.5972 18.1177 16.7193 20.2765C16.7249 20.343 16.7267 20.4097 16.7245 20.4764Z" fill="currentColor"/>
                                </svg>
                            </div>
                            <div class="item--text"><?php echo esc_html($title_testimonial); ?></div>
                            <div class="item--description"><?php echo esc_html($description); ?></div>
                        </div>
                        <div class="item--holder">
                            <?php if(!empty($image)) { ?>
                                <div class="item--image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php } ?>
                            <div class="item--meta">
                                <h3 class="item--title">    
                                    <?php echo esc_attr($title); ?>
                                </h3>
                                <div class="item--position"><?php echo esc_attr($position); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    </div>
<?php endif; ?>
