<?php
$widget->add_render_attribute('inner', [
    'class' => 'ct-carousel-inner',
]);

$col_xs = 1;
$col_sm = 1;
$col_md = 1;
$col_lg = 1;
$col_xl = 1;
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute('carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style2 nav-middle1',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
]);
?>
<?php if (isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel26 ct-slick-slider <?php echo esc_attr($settings['style_l1']); ?>">
        <div <?php ct_print_html($widget->get_render_attribute_string('inner')); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string('carousel')); ?>>
                <?php foreach ($settings['testimonial'] as $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : ''; 
                    $logo = isset($value['logo']) ? $value['logo'] : ''; ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item--icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="88" height="88" viewBox="0 0 88 88" fill="none">
                                    <path d="M21.9298 79.466C16.7676 79.4604 11.8185 77.4072 8.1683 73.757C4.51808 70.1068 2.4649 65.1576 2.45924 59.9954C2.45924 59.9633 2.45924 59.93 2.45924 59.8979C2.45924 59.8337 2.45091 59.7374 2.44378 59.6101C2.04421 52.5392 3.2001 33.448 22.5161 8.98517C22.6901 8.76547 22.936 8.61425 23.2106 8.55821C23.4852 8.50216 23.7707 8.54488 24.0169 8.67883C24.263 8.81279 24.4539 9.02936 24.556 9.29036C24.658 9.55136 24.6646 9.84001 24.5746 10.1054C24.5199 10.2671 19.2411 26.0798 22.8479 40.5486C27.928 40.787 32.7133 43.0037 36.1803 46.7245C39.6473 50.4453 41.5209 55.375 41.4003 60.4594C41.2798 65.5437 39.1747 70.379 35.5352 73.9314C31.8958 77.4837 27.0108 79.4711 21.9251 79.4684L21.9298 79.466ZM4.83762 60.0632C4.85078 63.4409 5.86439 66.7389 7.75049 69.5409C9.63659 72.343 12.3106 74.5234 15.4349 75.8068C18.5593 77.0903 21.9938 77.4193 25.305 76.7523C28.6162 76.0853 31.6555 74.4522 34.0392 72.0591C36.4229 69.6661 38.0442 66.6205 38.6983 63.3067C39.3525 59.993 39.0101 56.5598 37.7145 53.4404C36.4189 50.3211 34.2281 47.6556 31.4188 45.7804C28.6095 43.9052 25.3075 42.9044 21.9298 42.9044C21.6694 42.9044 21.4162 42.8188 21.2091 42.6609C21.002 42.503 20.8525 42.2815 20.7835 42.0304C18.0483 32.0769 19.3897 21.6358 20.749 15.2998C5.42745 36.7623 4.4654 53.1445 4.82335 59.477C4.8395 59.6719 4.84426 59.8677 4.83762 60.0632Z" fill="currentColor"/>
                                    <path d="M66.151 79.466C60.9888 79.4604 56.0397 77.4072 52.3895 73.757C48.7393 70.1068 46.6861 65.1576 46.6804 59.9954C46.6804 59.9633 46.6804 59.93 46.6804 59.8979C46.6804 59.8337 46.6721 59.7374 46.665 59.6101C46.2654 52.5392 47.4213 33.448 66.7373 8.98517C66.9112 8.76547 67.1572 8.61425 67.4318 8.55821C67.7064 8.50216 67.9919 8.54488 68.2381 8.67883C68.4842 8.81279 68.6751 9.02936 68.7772 9.29036C68.8792 9.55136 68.8858 9.84001 68.7958 10.1054C68.7411 10.2671 63.4623 26.0798 67.0691 40.5486C72.1492 40.787 76.9345 43.0037 80.4015 46.7245C83.8685 50.4453 85.7421 55.375 85.6215 60.4594C85.501 65.5437 83.3959 70.379 79.7564 73.9314C76.1169 77.4837 71.232 79.4711 66.1463 79.4684L66.151 79.466ZM49.0588 60.0632C49.072 63.4409 50.0856 66.7389 51.9717 69.5409C53.8578 72.343 56.5318 74.5234 59.6561 75.8068C62.7805 77.0903 66.215 77.4193 69.5262 76.7523C72.8373 76.0853 75.8767 74.4522 78.2604 72.0591C80.6441 69.6661 82.2654 66.6205 82.9195 63.3067C83.5737 59.993 83.2313 56.5598 81.9357 53.4404C80.6401 50.3211 78.4493 47.6556 75.64 45.7804C72.8307 43.9052 69.5287 42.9044 66.151 42.9044C65.8906 42.9044 65.6374 42.8188 65.4303 42.6609C65.2232 42.503 65.0737 42.2815 65.0046 42.0304C62.2695 32.0769 63.6109 21.6358 64.9702 15.2998C49.6486 36.7623 48.6854 53.1445 49.0433 59.477C49.0599 59.6719 49.0651 59.8677 49.0588 60.0632Z" fill="currentColor"/>
                                </svg>
                            </div>
                            <div class="item--sub-title"><?php echo esc_html($sub_title); ?></div>
                            <div class="item--description"><?php echo esc_html($description); ?></div>
                            <div class="item-holder">
                                <?php if (!empty($image['id'])) {
                                    $img_image = consultio_get_image_by_size(array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => 'full',
                                    ));
                                    $thumbnail_image = $img_image['thumbnail']; ?>
                                    <div class="item--image">
                                        <?php echo wp_kses_post($thumbnail_image); ?>
                                    </div>
                                <?php } ?>
                                <div class="item-meta">
                                    <h3 class="item--title">
                                        <?php echo esc_attr($title); ?>
                                    </h3>
                                    <div class="item--position"><?php echo esc_attr($position); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>