<?php
$widget->add_render_attribute('inner', [
    'class' => 'ct-carousel-inner',
]);

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute('carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style2 nav-middle1',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
]);
?>
<?php if (isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel23 ct-slick-slider <?php echo esc_attr($settings['style_l1']); ?>">
        <div <?php ct_print_html($widget->get_render_attribute_string('inner')); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string('carousel')); ?>>
                <?php foreach ($settings['testimonial'] as $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $logo = isset($value['logo']) ? $value['logo'] : ''; ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item--header">
                                <div class="item--holder">
                                    <div class="item--meta">
                                        <h3 class="item--title">
                                            <?php echo esc_attr($title); ?>
                                        </h3>
                                        <div class="item--position"><?php echo esc_attr($position); ?></div>
                                    </div>
                                    <div class="item--rating">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </div>
                                </div>
                                <?php if (!empty($logo['id'])) {
                                    $img_logo = consultio_get_image_by_size(array(
                                        'attach_id'  => $logo['id'],
                                        'thumb_size' => 'full',
                                    ));
                                    $thumbnail_logo = $img_logo['thumbnail']; ?>
                                    <div class="item--logo">
                                        <?php echo wp_kses_post($thumbnail_logo); ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="34" height="25" viewBox="0 0 34 25" fill="none">
                                            <path d="M25.7284 0C30.1953 0 33.8163 3.62108 33.8163 8.08791C33.8163 11.3872 32.0988 14.5794 29.5354 15.1954C28.5467 15.433 27.7592 16.7019 27.9284 18.1505C28.1549 20.0894 29.9082 22.0482 33.3798 23.5919C34.1528 23.9356 33.8291 25.0984 32.9897 24.9933C23.9422 23.8606 17.6707 17.9622 17.6406 9.61703C17.6405 3.87786 21.0313 0 25.7284 0Z" fill="#F7F5EF" />
                                            <path d="M8.08781 0C12.5546 0 16.1757 3.62108 16.1757 8.08791C16.1757 11.3872 14.4582 14.5794 11.8948 15.1954C10.906 15.433 10.1186 16.7019 10.2878 18.1505C10.5142 20.0894 12.2676 22.0482 15.7392 23.5919C16.5122 23.9356 16.1885 25.0984 15.3491 24.9933C6.30158 23.8606 0.030087 17.9622 2.59728e-09 9.61703C-0.000108361 3.87786 3.39063 0 8.08781 0Z" fill="#F7F5EF" />
                                        </svg>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="item--divider"></div>
                            <div class="item--description"><span class="item--quote">“</span><?php echo esc_html($description); ?><span class="item--quote">”</span></div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>