<?php
    $html_id = ct_get_element_id($settings);
    $tab_type = $widget->get_setting('tab_type', 'horizontal');
    $tab_style = $widget->get_setting('tab_style', 'style1');
    $active_tab = $widget->get_setting('active_tab', 1);
    $tabs = $widget->get_setting('tabs', '');
    $tabs_title = [];
    $tabs_content = [];
    $is_new = \Elementor\Icons_Manager::is_migration_allowed();
    foreach ($tabs as $key => $tab){
        $title_key = $widget->get_repeater_setting_key( 'tab_title', 'tabs', $key );
        $content_key = $widget->get_repeater_setting_key( 'tab_content', 'tabs', $key );

        $tabs_title[$title_key] = $tab['tab_title'];
        $tabs_content[$content_key] = '';
        if($tab['content_type'] == 'template'){
            if(!empty($tab['tab_content_template'])){
                $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $tab['tab_content_template'] );
                $tabs_content[$content_key] = $content;
            }
        }
        $form_class = '';
        if($tab['content_type'] == 'form') {
            $form_class = 'ct-contact-form-layout1 style8';
            if(!empty($tab['form_id'])) {
                $tabs_content[$content_key] = do_shortcode('[contact-form-7 id="'.esc_attr( $tab['form_id'] ).'"]');
            }
        }
        elseif($tab['content_type'] == 'text_editor'){
            $tabs_content[$content_key] = $tab['tab_content'];
        }

        $widget->add_render_attribute( $title_key, [
            'class' => [ 'ct-tab-title' ],
            'data-target' => '#' . $html_id.'-'.$tab['_id'],
        ] );

        $widget->add_inline_editing_attributes( $title_key, 'basic' );
        $widget->add_render_attribute( $content_key, [
            'class' => [ 'ct-tab-content', $form_class ],
            'id' => $html_id.'-'.$tab['_id'],
        ] );
        if($tab['content_type'] == 'text_editor'){
            $widget->add_inline_editing_attributes( $content_key, 'advanced' );
        }

        if($active_tab == $key + 1){
            $widget->add_render_attribute( $content_key, 'style', 'display:block;');
            $widget->add_render_attribute( $title_key, 'class', 'active');
        }
    }
    switch ($tab_type) {
        case 'horizontal': ?>
            <div class="ct-tabs ct-tabs--layout1 type-<?php echo esc_attr($tab_type); ?> <?php echo esc_attr($tab_style); ?>">
                <div class="ct-tabs-title">
                    <?php foreach ($tabs as $key => $tab) : 
                        $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                        $has_icon = ! empty( $tab['ct_icon'] );
                        $widget->add_render_attribute( $icon_key, [
                            'class' => $tab['ct_icon'],
                            'aria-hidden' => 'true',
                        ] );
                        ?>
                        <span class="ct-tab-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$tab['_id']); ?>">
                            <?php
                                if($is_new):
                                    \Elementor\Icons_Manager::render_icon( $tab['ct_icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <?php else: ?>
                                <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                            <?php endif; ?>
                            <?php echo ct_print_html($tab['tab_title']); ?>        
                        </span>
                    <?php endforeach; ?>
                </div>

                <div class="ct-tabs-content">
                    <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                        <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php break;

        case 'vertical2': ?>
            <div class="ct-tabs ct-tabs--layout2 type-<?php echo esc_attr($tab_type); ?> <?php echo esc_attr($tab_style); ?>">
                <div class="ct-tabs-title">
                    <?php foreach ($tabs as $key => $tab) : 
                        $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                        $has_icon = ! empty( $tab['ct_icon'] );
                        $widget->add_render_attribute( $icon_key, [
                            'class' => $tab['ct_icon'],
                            'aria-hidden' => 'true',
                        ] );
                        ?>
                        <span class="ct-tab-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$tab['_id']); ?>">
                            <?php
                                if($is_new):
                                    \Elementor\Icons_Manager::render_icon( $tab['ct_icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <?php else: ?>
                                <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                            <?php endif; ?>
                            <?php echo ct_print_html($tab['tab_title']); ?>        
                        </span>
                    <?php endforeach; ?>
                </div>

                <div class="ct-tabs-content">
                    <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                        <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php break;

        case 'vertical3': ?>
            <div class="ct-tabs ct-tabs--layout3 type-<?php echo esc_attr($tab_type); ?> <?php echo esc_attr($tab_style); ?>">
                <div class="ct-tabs-title">
                    <?php foreach ($tabs as $key => $tab) : 
                        $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                        $has_icon = ! empty( $tab['ct_icon'] );
                        $widget->add_render_attribute( $icon_key, [
                            'class' => $tab['ct_icon'],
                            'aria-hidden' => 'true',
                        ] );
                        ?>
                        <span class="ct-tab-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$tab['_id']); ?>">
                            <?php
                                if($is_new):
                                    \Elementor\Icons_Manager::render_icon( $tab['ct_icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <?php else: ?>
                                <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                            <?php endif; ?>
                            <?php echo ct_print_html($tab['tab_title']); ?>
                            <div class="ct-tab-arrow">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                  <g clip-path="url(#clip0_1_3174)">
                                    <path d="M10.135 14.2839C10.1368 14.2821 10.1386 14.2803 10.1404 14.2785L15.7414 8.68488C15.7856 8.64044 15.8248 8.59132 15.8585 8.53844L15.9464 8.37738L15.983 8.26755L15.983 8.18701C16.0057 8.06359 16.0057 7.93705 15.983 7.81361L15.983 7.7404L15.983 7.65254L15.9171 7.52807C15.8794 7.45871 15.8326 7.39467 15.778 7.3377L10.1404 1.72211C9.76735 1.34607 9.16006 1.34363 8.78402 1.71668C8.7822 1.71847 8.78042 1.72029 8.7786 1.72211C8.41694 2.10117 8.41694 2.69751 8.7786 3.0766L12.1172 6.42253C12.2588 6.56688 12.2565 6.79867 12.1121 6.94021C12.0449 7.00606 11.955 7.04354 11.861 7.04485L0.959207 7.04485C0.429483 7.04481 4.16978e-05 7.47418 7.34241e-06 8.00391C-2.7013e-05 8.53363 0.429346 8.96304 0.95907 8.96311L0.959207 8.96311L11.861 8.96311C12.0631 8.96596 12.2247 9.13213 12.2219 9.33428C12.2205 9.42831 12.1831 9.51826 12.1172 9.58543L8.7786 12.9167C8.41227 13.2968 8.41227 13.8985 8.7786 14.2785C9.15166 14.6546 9.75894 14.657 10.135 14.2839Z" fill="currentColor"/>
                                  </g>
                                  <defs>
                                    <clipPath id="clip0_1_3174">
                                      <path d="M11 -2.18557e-07C13.7614 -9.78513e-08 16 2.23858 16 5L16 16L-6.99382e-07 16L-2.18557e-07 5C-9.78513e-08 2.23858 2.23858 -6.01531e-07 5 -4.80825e-07L11 -2.18557e-07Z" fill="white"/>
                                    </clipPath>
                                  </defs>
                                </svg>
                            </div>
                        </span>
                    <?php endforeach; ?>
                </div>

                <div class="ct-tabs-content">
                    <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                        <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php break;

        case 'vertical4': ?>
            <div class="ct-tabs ct-tabs--layout4 type-<?php echo esc_attr($tab_type); ?> <?php echo esc_attr($tab_style); ?>">
                <div class="ct-tabs-content">
                    <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                        <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
                    <?php endforeach; ?>
                </div>
                <div class="ct-tabs-title">
                    <?php foreach ($tabs as $key => $tab) : 
                        $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                        $has_icon = ! empty( $tab['ct_icon'] );
                        $widget->add_render_attribute( $icon_key, [
                            'class' => $tab['ct_icon'],
                            'aria-hidden' => 'true',
                        ] );
                        ?>
                        <span class="ct-tab-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$tab['_id']); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" viewBox="0 0 42 42" fill="none">
                                <g clip-path="url(#clip0_1_1951)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M42 21C42 9.43359 32.5664 3.88351e-07 21 2.50422e-07C9.43359 1.12494e-07 3.88351e-07 9.43359 2.50422e-07 21C1.12494e-07 32.5664 9.43359 42 21 42C32.5664 42 42 32.5664 42 21Z" fill="#FE5B2B"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M20.4914 15.2168L14.7082 21L20.4914 26.7832L24.9621 26.7832L20.7539 22.575L30.4007 22.575L33.6 22.575C34.5351 15.0364 28.6945 8.2934 21 8.2934C13.9863 8.2934 8.30151 13.9782 8.30151 21C8.30151 28.0219 13.9863 33.6985 21 33.6985C26.6273 33.6985 31.3933 30.0399 33.0668 24.9786L29.6707 24.9786C28.1613 28.2598 24.8472 30.5321 21 30.5321C15.7335 30.5321 11.4597 26.2582 11.4597 20.9918C11.4597 15.7254 15.7335 11.4516 21 11.4516C25.7332 11.4516 29.6543 14.8969 30.4089 19.4086L20.7621 19.4086L24.9703 15.2004L20.4914 15.2004L20.4914 15.2168Z" fill="white"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M23.8464 0.188563L12.0175 12.0175C14.3144 9.7206 17.489 8.29325 20.9999 8.29325C28.6945 8.29326 34.5351 15.0362 33.6081 22.5749L30.4089 22.5749L20.7621 22.5749L24.9703 26.7831L20.4996 26.7831L14.7164 20.9999L20.4996 15.2167L24.9703 15.2167L20.7621 19.4249L30.4089 19.4249C29.6542 14.9132 25.7331 11.4679 20.9999 11.4679C15.7335 11.4679 11.4597 15.7417 11.4597 21.0081C11.4597 26.2745 15.7335 30.5483 20.9999 30.5483C24.8472 30.5483 28.1613 28.2679 29.6706 24.9948L33.0667 24.9948C32.4433 26.8815 31.3851 28.5796 30.0152 29.9577L41.8031 18.1698C40.548 8.83466 33.1652 1.45185 23.8464 0.188563Z" fill="#CB4018"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_1951">
                                    <rect width="42" height="42" fill="white" transform="translate(0 42) rotate(-90)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <span><?php echo ct_print_html($tab['tab_title']); ?></span>        
                        </span>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php break;
        
        default: ?>
            <div class="ct-tabs ct-tabs--layout2 type-<?php echo esc_attr($tab_type); ?> <?php echo esc_attr($tab_style); ?>">
                <div class="ct-tabs-title">
                    <?php foreach ($tabs_title as $title_key => $tab_title): ?>
                        <span <?php ct_print_html($widget->get_render_attribute_string( $title_key )); ?>><span><?php echo ct_print_html($tab_title); ?></span></span>
                    <?php endforeach; ?>
                </div>

                <div class="ct-tabs-content">
                    <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                        <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php break;
    }

?>