<?php
$default_settings = [
    'counter_number' => '',
    'counter_title' => '',
    'number' => '',
    'title' => '',
	'counter_suffix' => '',
	'image' => '',
	'image_2' => '',
	'image_3' => '',
	'image_4' => '',
	'ct_animate' => '',
	'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
?>

<div class="ct-client-counter1 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-client-counter-wrapper">
        <div class="ct-client-counter-item">
            <img src="<?php echo esc_url($image['url']); ?>" alt="">
        </div>
        <div class="ct-client-counter-item">
            <img src="<?php echo esc_url($image_2['url']); ?>" alt="">
        </div>
        <div class="ct-client-counter-item">
            <img src="<?php echo esc_url($image_3['url']); ?>" alt="">
        </div>
        <div class="ct-client-counter-item">
            <img src="<?php echo esc_url($image_4['url']); ?>" alt="">
            <div class="item-counter">
                <?php if(!empty($counter_number)) : ?>
                    <div class="counter-number">
                        <div class="couter-holder">
                            <span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
                            <span class="counter-suffix"><?php echo esc_attr($counter_suffix); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <h3 class="ct-client-counter-title"><?php echo esc_attr($title); ?></h3>
</div>