<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_date = $widget->get_setting('show_date');
$show_author = $widget->get_setting('show_author');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size = $widget->get_setting('thumbnail_size', 'full');
$thumbnail_custom_dimension = $widget->get_setting('thumbnail_custom_dimension', '');
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '680x410';
}
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout12 ct-slick-slider slick-boxshadow">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>

        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $author = get_user_by('id', $post->post_author); ?>
            <div class="carousel-item slick-slide">
                <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = consultio_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $img_size,
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <h3 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                    <div class="item--divider"></div>
                    <div class="item--holder">
                        <div class="item--meta">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                <g clip-path="url(#clip0_1_3030)">
                                    <path d="M14.2857 1.71428L12.5714 1.71428V0.571439C12.5714 0.255837 12.3156 0 12 0C11.6844 0 11.4286 0.255837 11.4286 0.571439V1.71428L4.57141 1.71428V0.571439C4.57141 0.255837 4.31558 0 4.00001 0C3.68444 0 3.42857 0.255837 3.42857 0.571439L3.42857 1.71428L1.71428 1.71428C0.767511 1.71428 0 2.4818 0 3.42857L0 14.2857C0 15.2325 0.767511 16 1.71428 16L14.2857 16C15.2325 16 16 15.2325 16 14.2857L16 3.42857C16 2.4818 15.2325 1.71428 14.2857 1.71428ZM14.8571 14.2857C14.8571 14.6013 14.6013 14.8572 14.2857 14.8572L1.71428 14.8572C1.39868 14.8572 1.14285 14.6013 1.14285 14.2857L1.14285 6.85714L14.8571 6.85714V14.2857ZM14.8571 5.71429L1.14285 5.71429L1.14285 3.42857C1.14285 3.11297 1.39868 2.85713 1.71428 2.85713H3.42857V3.99997C3.42857 4.31558 3.68441 4.57141 4.00001 4.57141C4.31561 4.57141 4.57145 4.31558 4.57145 3.99997V2.85713L11.4286 2.85713V3.99997C11.4286 4.31558 11.6844 4.57141 12 4.57141C12.3156 4.57141 12.5715 4.31558 12.5715 3.99997V2.85713H14.2857C14.6014 2.85713 14.8572 3.11297 14.8572 3.42857L14.8572 5.71429H14.8571Z" fill="currentColor"/>
                                    <path d="M4.57122 8H3.42837C3.11277 8 2.85693 8.25584 2.85693 8.57144C2.85693 8.88704 3.11277 9.14288 3.42837 9.14288H4.57122C4.88682 9.14288 5.14266 8.88704 5.14266 8.57144C5.14266 8.25584 4.88682 8 4.57122 8Z" fill="currentColor"/>
                                    <path d="M8.57122 8H7.42837C7.11277 8 6.85693 8.25584 6.85693 8.57144C6.85693 8.88704 7.11277 9.14288 7.42837 9.14288H8.57122C8.88682 9.14288 9.14266 8.88704 9.14266 8.57144C9.14266 8.25584 8.88682 8 8.57122 8Z" fill="currentColor"/>
                                    <path d="M12.5712 8H11.4284C11.1128 8 10.8569 8.25584 10.8569 8.57144C10.8569 8.88704 11.1128 9.14288 11.4284 9.14288H12.5712C12.8868 9.14288 13.1427 8.88704 13.1427 8.57144C13.1426 8.25584 12.8868 8 12.5712 8Z" fill="currentColor"/>
                                    <path d="M4.57171 10.2852H3.42886C3.11326 10.2852 2.85742 10.541 2.85742 10.8566C2.85742 11.1722 3.11326 11.428 3.42886 11.428H4.57171C4.88731 11.428 5.14315 11.1722 5.14315 10.8566C5.14315 10.541 4.88731 10.2852 4.57171 10.2852Z" fill="currentColor"/>
                                    <path d="M8.57171 10.2852H7.42886C7.11326 10.2852 6.85742 10.541 6.85742 10.8566C6.85742 11.1722 7.11326 11.428 7.42886 11.428H8.57171C8.88731 11.428 9.14315 11.1722 9.14315 10.8566C9.14315 10.541 8.88731 10.2852 8.57171 10.2852Z" fill="currentColor"/>
                                    <path d="M12.5717 10.2852H11.4289C11.1133 10.2852 10.8574 10.541 10.8574 10.8566C10.8574 11.1722 11.1133 11.428 11.4289 11.428H12.5717C12.8873 11.428 13.1431 11.1722 13.1431 10.8566C13.1431 10.541 12.8873 10.2852 12.5717 10.2852Z" fill="currentColor"/>
                                    <path d="M4.57122 12.5713H3.42837C3.11277 12.5713 2.85693 12.8271 2.85693 13.1427C2.85693 13.4583 3.11277 13.7141 3.42837 13.7141H4.57122C4.88682 13.7141 5.14266 13.4583 5.14266 13.1427C5.14266 12.8271 4.88682 12.5713 4.57122 12.5713Z" fill="currentColor"/>
                                    <path d="M8.57122 12.5713H7.42837C7.11277 12.5713 6.85693 12.8271 6.85693 13.1427C6.85693 13.4583 7.11277 13.7142 7.42837 13.7142H8.57122C8.88682 13.7142 9.14266 13.4583 9.14266 13.1427C9.14266 12.8271 8.88682 12.5713 8.57122 12.5713Z" fill="currentColor"/>
                                    <path d="M12.5712 12.5713H11.4284C11.1128 12.5713 10.8569 12.8271 10.8569 13.1427C10.8569 13.4583 11.1128 13.7142 11.4284 13.7142H12.5712C12.8868 13.7142 13.1427 13.4583 13.1427 13.1427C13.1427 12.8271 12.8868 12.5713 12.5712 12.5713Z" fill="currentColor"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_3030">
                                    <rect width="16" height="16" fill="white"/>
                                    </clipPath>
                                </defs>
                                </svg>
                            <?php if($show_date == 'true'): ?>
                                <span class="item--date">
                                    <?php echo get_the_date('j F, Y', $post->ID); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                        <?php if($show_button == 'true'): ?>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn-readmore"><?php echo esc_attr($button_text); ?>
                                <span>Learn more</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                    <g clip-path="url(#clip0_1_3064)">
                                        <path d="M8.86811 12.4986C8.8697 12.497 8.87126 12.4954 8.87285 12.4938L13.7737 7.59939C13.8124 7.5605 13.8467 7.51753 13.8762 7.47126L13.9531 7.33033L13.9851 7.23423L13.9851 7.16375C14.005 7.05576 14.005 6.94504 13.9851 6.83703L13.9851 6.77297L13.9851 6.6961L13.9275 6.58718C13.8945 6.52649 13.8536 6.47046 13.8057 6.42061L8.87285 1.50696C8.54643 1.17793 8.01506 1.1758 7.68602 1.50222C7.68443 1.50378 7.68287 1.50537 7.68128 1.50696C7.36482 1.83864 7.36482 2.36044 7.68128 2.69215L10.6026 5.61983C10.7264 5.74614 10.7244 5.94896 10.5981 6.0728C10.5393 6.13043 10.4606 6.16322 10.3783 6.16436L0.839306 6.16436C0.375797 6.16433 3.60088e-05 6.54003 6.42461e-06 7.00354C-2.41132e-05 7.46705 0.375677 7.84278 0.839185 7.84284L0.839306 7.84284L10.3783 7.84284C10.5552 7.84534 10.6966 7.99074 10.6941 8.16761C10.693 8.2499 10.6602 8.3286 10.6026 8.38737L7.68128 11.3023C7.36074 11.6348 7.36074 12.1613 7.68128 12.4938C8.0077 12.8229 8.53907 12.825 8.86811 12.4986Z" fill="currentColor"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1_3064">
                                        <path d="M9 -2.18557e-07C11.7614 -9.78513e-08 14 2.23858 14 5L14 14L-6.11959e-07 14L-2.18557e-07 5C-9.78513e-08 2.23858 2.23858 -5.14108e-07 5 -3.93402e-07L9 -2.18557e-07Z" fill="white"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>