<?php
$default_settings = [
    'counter_number' => '',
    'counter_title' => '',
    'counter_suffix' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

// Image 2
if ( ! empty( $settings['image_2']['url'] ) ) {
    $widget->add_render_attribute( 'image_2', 'src', $settings['image_2']['url'] );
    $widget->add_render_attribute( 'image_2', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image_2'] ) );
    $widget->add_render_attribute( 'image_2', 'title', \Elementor\Control_Media::get_image_title( $settings['image_2'] ) );
}
$image_html_2 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image_2' );

// Image 3
if ( ! empty( $settings['image_3']['url'] ) ) {
    $widget->add_render_attribute( 'image_3', 'src', $settings['image_3']['url'] );
    $widget->add_render_attribute( 'image_3', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image_3'] ) );
    $widget->add_render_attribute( 'image_3', 'title', \Elementor\Control_Media::get_image_title( $settings['image_3'] ) );
}
$image_html_3 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image_3' );

// Image 4
if ( ! empty( $settings['image_4']['url'] ) ) {
    $widget->add_render_attribute( 'image_4', 'src', $settings['image_4']['url'] );
    $widget->add_render_attribute( 'image_4', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image_4'] ) );
    $widget->add_render_attribute( 'image_4', 'title', \Elementor\Control_Media::get_image_title( $settings['image_4'] ) );
}
$image_html_4 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image_4' );
?>
<div class="ct-banner9 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-banner--inner">
        <div class="ct-banner-left">
            <?php if ( ! empty( $image_html ) ) : ?>
                <div class="ct-banner-image">
                    <?php echo wp_kses_post($image_html); ?>
                </div>
            <?php endif; ?>
            <?php if ( ! empty( $image_html_3 ) ) : ?>
                <div class="ct-banner-image-3">
                    <?php echo wp_kses_post($image_html_3); ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="ct-banner-right">
            <?php if ( ! empty( $image_html_2 ) ) : ?>
                <div class="ct-banner-image-2">
                    <?php echo wp_kses_post($image_html_2); ?>
                    <div class="ct-banner-counter">
                        <div class="counter-holder">
                            <?php if(!empty($counter_number)) : ?>
                                <div class="counter-number">
                                    <span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
                                    <span class="ct-counter-number-suffix"><?php echo esc_attr($counter_suffix); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($counter_title)) : ?>
                                <div class="counter-title">
                                    <?php echo esc_attr($counter_title); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ( ! empty( $image_html_4 ) ) : ?>
                <div class="ct-banner-image-4">
                    <?php echo wp_kses_post($image_html_4); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="ct-banner-counter-2">
        <div class="counter-holder">
            <?php if(!empty($counter_number)) : ?>
                <div class="counter-number">
                    <span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
                    <span class="ct-counter-number-suffix"><?php echo esc_attr($counter_suffix); ?></span>
                </div>
            <?php endif; ?>
            <?php if(!empty($counter_title)) : ?>
                <div class="counter-title">
                    <?php echo esc_attr($counter_title); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>