<?php
$default_settings = [
    'counter_number' => '',
    'counter_title' => '',
    'number' => '',
    'title' => '',
	'counter_suffix' => '',
	'counter_number_2' => '',
	'counter_title_2' => '',
	'counter_suffix_2' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

if ( ! empty( $settings['client_image']['url'] ) ) {
    $widget->add_render_attribute( 'client_image', 'src', $settings['client_image']['url'] );
    $widget->add_render_attribute( 'client_image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['client_image'] ) );
    $widget->add_render_attribute( 'client_image', 'title', \Elementor\Control_Media::get_image_title( $settings['client_image'] ) );
}
$client_image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'client_image' );

if ( ! empty( $settings['client_image_2']['url'] ) ) {
    $widget->add_render_attribute( 'client_image_2', 'src', $settings['client_image_2']['url'] );
    $widget->add_render_attribute( 'client_image_2', 'alt', \Elementor\Control_Media::get_image_alt( $settings['client_image_2'] ) );
    $widget->add_render_attribute( 'client_image_2', 'title', \Elementor\Control_Media::get_image_title( $settings['client_image_2'] ) );
}
$client_image_html_2 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'client_image_2' );

if ( ! empty( $settings['client_image_3']['url'] ) ) {
    $widget->add_render_attribute( 'client_image_3', 'src', $settings['client_image_3']['url'] );
    $widget->add_render_attribute( 'client_image_3', 'alt', \Elementor\Control_Media::get_image_alt( $settings['client_image_3'] ) );
    $widget->add_render_attribute( 'client_image_3', 'title', \Elementor\Control_Media::get_image_title( $settings['client_image_3'] ) );
}
$client_image_html_3 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'client_image_3' );
?>
<div class="ct-banner8 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
	<div class="ct-banner-inner">
		<?php if(!empty($settings['image']['url'])) : ?>
			<img class="ct-banner-image" src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo \Elementor\Control_Media::get_image_alt( $settings['image'] ); ?>">
			<div class="item-holder">
				<div class="item-client-list">
					<div class="item-client">
						<img <?php echo $widget->get_render_attribute_string( 'client_image' ); ?>>
					</div>
					<div class="item-client">
						<img <?php echo $widget->get_render_attribute_string( 'client_image_2' ); ?>>
					</div>
					<div class="item-client">
						<img <?php echo $widget->get_render_attribute_string( 'client_image_3' ); ?>>
						<?php if(!empty($counter_number)) : ?>
							<div class="counter-number">
								<div class="couter-holder">
									<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
									<span class="counter-suffix"><?php echo esc_attr($counter_suffix); ?></span>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
				<div class="item-text">
					<?php if(!empty($counter_number_2)) : ?>
						<div class="counter-number">
							<div class="couter-holder">
								<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number_2); ?>">1</span>
								<span class="counter-suffix"><?php echo esc_attr($counter_suffix_2); ?></span>
							</div>
							<?php if(!empty($counter_title_2)) : ?>
								<h2><?php echo esc_html($counter_title_2); ?></h2>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>
    </div>
</div>