<?php
use Elementor\Icons_Manager;
Icons_Manager::enqueue_shim();
$default_settings = [
    'active_section' => '',
    'ct_accordion' => '',
    'main_icon' => '',
    'icon_active' => '',
    'title_html_tag' => 'div',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = ct_get_element_id($settings);
$active_section = intval($active_section);
$accordions = $widget->get_settings('ct_accordion');
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(!empty($accordions)) : ?>
    <div id="<?php echo esc_attr($html_id); ?>" class="ct-accordion layout7 <?php echo esc_attr($ct_animate); ?>">
        <?php foreach ($accordions as $key => $value):
            $is_active = ($key + 1) == $active_section;
            $_id = isset($value['_id']) ? $value['_id'] : '';
            $ac_title = isset($value['ac_title']) ? $value['ac_title'] : '';
            $ac_content = isset($value['ac_content']) ? $value['ac_content'] : '';

            $title_key = $widget->get_repeater_setting_key( 'ac_title', 'ct_accordion', $key );
            $widget->add_render_attribute( $title_key, [
                'class' => [ 'ct-ac-title-text' ],
            ] );
            $widget->add_inline_editing_attributes( $title_key, 'basic' );

            $content_key = $widget->get_repeater_setting_key( 'ac_content', 'ct_accordion', $key );
            $widget->add_render_attribute( $content_key, [
                'id' => $_id.$html_id,
                'class' => [ 'ct-ac-content' ],
            ] );
            if($is_active){
                $widget->add_render_attribute( $content_key, 'style', 'display:block;' );
            }
            $widget->add_inline_editing_attributes( $content_key, 'basic' );
            $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
            $has_icon = ! empty( $value['ct_icon'] );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['ct_icon'],
                'aria-hidden' => 'true',
            ] );
            ?>
            <div class="ct-accordion-item <?php echo esc_attr($is_active?'active':''); ?>">
                <<?php ct_print_html($title_html_tag); ?> class="ct-ac-title <?php echo esc_attr($is_active?'active':''); ?>" data-target="<?php echo esc_attr('#' . $_id.$html_id); ?>">
                    <a <?php ct_print_html($widget->get_render_attribute_string( $title_key )); ?>>
                        <?php
                            if($is_new):
                                \Elementor\Icons_Manager::render_icon( $value['ct_icon'], [ 'aria-hidden' => 'true' ] );
                        ?>
                        <?php else: ?>
                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                        <?php endif; ?>
                        <div class="ct-ac-title-left">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <g clip-path="url(#clip0_1_4452)">
                                    <path d="M0 10C5 10 10 5 10 0C10 5 15 10 20 10C15 10 10 15 10 20C10 15 5 10 0 10Z" fill="currentColor"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_4452">
                                    <rect width="20" height="20" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <span><?php echo esc_html($ac_title); ?></span>
                        </div>
                        <div class="ct-ac-title-arrow">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                                <path d="M11.0001 17.4164C10.8181 17.4175 10.6398 17.3643 10.4881 17.2637C10.3363 17.163 10.218 17.0195 10.1482 16.8513C10.0784 16.6831 10.0602 16.498 10.096 16.3195C10.1318 16.141 10.22 15.9772 10.3493 15.8489L15.2076 10.9998L10.3493 6.15061C10.1991 5.97525 10.1206 5.74968 10.1296 5.51898C10.1385 5.28828 10.2341 5.06943 10.3974 4.90618C10.5606 4.74293 10.7795 4.64729 11.0102 4.63838C11.2409 4.62947 11.4664 4.70794 11.6418 4.85811L17.1418 10.3581C17.3125 10.5299 17.4084 10.7622 17.4084 11.0044C17.4084 11.2465 17.3125 11.4789 17.1418 11.6506L11.6418 17.1506C11.4711 17.32 11.2406 17.4154 11.0001 17.4164Z" fill="url(#paint0_linear_1_4446)"/>
                                <path d="M5.50012 17.4162C5.31805 17.4172 5.13979 17.3641 4.98806 17.2634C4.83633 17.1628 4.71802 17.0192 4.6482 16.851C4.57838 16.6829 4.56022 16.4977 4.59603 16.3192C4.63185 16.1407 4.72001 15.9769 4.84929 15.8487L9.70762 10.9995L4.84929 6.15035C4.67668 5.97774 4.57971 5.74363 4.57971 5.49952C4.57971 5.25541 4.67668 5.0213 4.84929 4.84869C5.0219 4.67607 5.25601 4.5791 5.50012 4.5791C5.74423 4.5791 5.97834 4.67607 6.15096 4.84869L11.651 10.3487C11.8217 10.5204 11.9175 10.7528 11.9175 10.9949C11.9175 11.2371 11.8217 11.4694 11.651 11.6412L6.15096 17.1412C6.06606 17.2278 5.96482 17.2967 5.8531 17.3439C5.74138 17.3911 5.6214 17.4157 5.50012 17.4162Z" fill="url(#paint1_linear_1_4446)"/>
                                <defs>
                                    <linearGradient id="paint0_linear_1_4446" x1="13.7432" y1="4.6377" x2="13.7432" y2="17.4165" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#2AF598"/>
                                    <stop offset="1" stop-color="#009EFD"/>
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_1_4446" x1="8.24783" y1="4.5791" x2="8.24783" y2="17.4162" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#2AF598"/>
                                    <stop offset="1" stop-color="#009EFD"/>
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                    </a>
                </<?php ct_print_html($title_html_tag); ?>>
                <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php echo wp_kses_post(nl2br($ac_content)); ?></div>
            </div>
        <?php
            endforeach;
        ?>
    </div>
<?php endif; ?>
